import java.util.Scanner;

/**
 * Grad students can be both graders and students.
 * When they grade, they return the similarity between
 * their own thesis and the assignment
 * @author Christie
 *
 */
public class GradStudent extends Student implements Grader
{
	private String thesis;
	public GradStudent(String name, String major, String thesis)
	{
		super(name, major);
		this.thesis = thesis;
	}
	
	@Override
	/**
	 * returns thesis for every assignment!
	 */
	public String submitAssignment(int num, String assignDesc) {
		return thesis;
	}
	
	@Override
	public double gradeAssignment(int assignmentNum, String assignment) {
		Scanner scn = new Scanner(assignment);
		int numContained = 0;
		int numWords = 0;
		while(scn.hasNext())
		{
			String currWord = scn.next();
			if (thesis.contains(currWord))
			{
				numContained++;
			}
			numWords++;
		}
		if (numWords == 0){
			System.out.println("huh?");
			return 0;
		}
		return ((double)numContained)/numWords;
	}

}
